from task2_3 import is_christmas_tree


# trida reprezentujici vrchol stromu, nemenit
class Node(object):
    def __init__(self, color, left=None, right=None):
        self.color = color
        self.left = left
        self.right = right

    def __str__(self):
        return "{color} [{left}] [{right}]".format(
            color=self.color if self.color is not None else '_',
            left=str(self.left) if self.left is not None else '',
            right=str(self.right) if self.right is not None else '')


# priklad dobre obarveneho stromu
good_tree = Node("Red",
                 Node("Green",
                      Node("Red"),
                      Node("Blue")),
                 Node("Blue",
                      None,
                      Node("Green")))

# priklad spatne obarveneho stromu
bad_tree = Node("Red",
                Node("Green",
                     Node("Red"),
                     Node("Blue")),
                Node("Blue",
                     None,
                     Node("Blue")))


print "Korektni strom: " + str(good_tree)
if is_christmas_tree(good_tree):
    print "   OK: Korekni strom byl uspesne vyhodnocen."
else:
    print "   Chyba: Korektni strom byl nebyl spravne vyhodnocen..."

print "Nekorektni strom: " + str(bad_tree)
if is_christmas_tree(bad_tree):
    print "   Chyba: Nekorektni storm nebyl spravne vyhodnocen..."
else:
    print "   OK: Nekorektni strom byl uspesne vyhodnocen."
